<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright ©2013 Fillip Hannisdal AKA Revan/NeoRevan/Belazor 	  # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

if (!class_exists('vB_DataManager', false))
{
	exit;
}

/**
* Class to do data save/delete operations for mailinglists
*
* @package	vbmail
*/
class vBMail_DataManager_Mailinglist extends vB_DataManager
{
	/**
	* Array of recognised and required fields for mailinglists, and their types
	*
	* @var	array
	*/
	var $validfields = array(
		'mailinglistid' 	=> array(TYPE_UINT, 	REQ_INCR, 	VF_METHOD, 	'verify_nonzero'),
		'title' 			=> array(TYPE_STR, 		REQ_YES, 	VF_METHOD),
		'description' 		=> array(TYPE_STR, 		REQ_NO),
		'active' 			=> array(TYPE_STR, 		REQ_NO, 	VF_METHOD, 	'verify_onoff'),
		'displayorder' 		=> array(TYPE_UINT, 	REQ_NO),		
		'ownerid' 			=> array(TYPE_UINT, 	REQ_NO, 	VF_METHOD, 	'verify_userid'),		
		'fromemail' 		=> array(TYPE_STR, 		REQ_YES, 	VF_METHOD, 	'verify_email'),
		'permissions' 		=> array(TYPE_NOCLEAN, 	REQ_NO, 	VF_METHOD, 	'verify_serialized'),
		'type' 				=> array(TYPE_STR, 		REQ_NO, 	VF_METHOD, 	'verify_offon'),
		'external' 			=> array(TYPE_STR, 		REQ_NO, 	VF_METHOD, 	'verify_offon'),
		'bitfield' 			=> array(TYPE_UINT, 	REQ_AUTO),
		'unsubscriptions' 	=> array(TYPE_UINT, 	REQ_NO),		
		'lastmailid' 		=> array(TYPE_UINT, 	REQ_NO),		
		'lastmaildateline' 	=> array(TYPE_UINT, 	REQ_NO),		
		'instantsend' 		=> array(TYPE_UINT, 	REQ_NO, 	VF_METHOD, 	'verify_onoff'),		
		'mailperpage' 		=> array(TYPE_UINT, 	REQ_NO),		
		'smtp' 				=> array(TYPE_NOCLEAN, 	REQ_NO, 	VF_METHOD, 	'verify_serialized'),
	);

	/**
	* Array of field names that are bitfields, together with the name of the variable in the registry with the definitions.
	*
	* @var	array
	*/
	//var $bitfields = array('adminpermissions' => 'bf_ugp_adminpermissions');

	/**
	* The main table this class deals with
	*
	* @var	string
	*/
	var $table = 'dbtech_vbmail_mailinglist';

	/**
	* Condition for update query
	*
	* @var	array
	*/
	var $condition_construct = array('mailinglistid = %1$d', 'mailinglistid');

	/**
	* Constructor - checks that the registry object has been passed correctly.
	*
	* @param	vB_Registry	Instance of the vBulletin data registry object - expected to have the database object as one of its $this->db member.
	* @param	integer		One of the ERRTYPE_x constants
	*/
	function vBMail_DataManager_Mailinglist(&$registry, $errtype = ERRTYPE_STANDARD)
	{
		parent::vB_DataManager($registry, $errtype);

		($hook = vBulletinHook::fetch_hook('dbtech_vbmail_mailinglistdata_start')) ? eval($hook) : false;
	}

	/**
	* Verifies that the title is valid
	*
	* @param	string	Title of the mailinglist
	*
	* @return	boolean
	*/
	function verify_title(&$title)
	{
		global $vbphrase;
		
		$title = strval($title);
		if ($title === '')
		{
			// Invalid
			return false;
		}
		
		// Check for existing mailinglist of this name
		if ($existing = $this->registry->db->query_first_slave("
			SELECT `title`
			FROM `" . TABLE_PREFIX . "dbtech_vbmail_mailinglist`
			WHERE `title` = " . $this->registry->db->sql_prepare($title) . "
				" . ($this->existing['mailinglistid'] ? "AND `mailinglistid` != " . $this->registry->db->sql_prepare($this->existing['mailinglistid']) : '') . "			
			LIMIT 1
		"))
		{
			// Whoopsie, exists
			$this->error('dbtech_vbmail_x_already_exists_y', $vbphrase['dbtech_vbmail_mailinglist'], $title);
			return false;
		}

		return true;
	}

	/**
	* Verifies that the onoff flag is valid
	*
	* @param	string	On/Off flag
	*
	* @return	boolean
	*/
	function verify_onoff(&$onoff)
	{
		// Validate onoff
		$onoff = (!in_array($onoff, array('0', '1')) ? '1' : $onoff);
		
		return true;
	}

	/**
	* Verifies that the onoff flag is valid
	*
	* @param	string	On/Off flag
	*
	* @return	boolean
	*/
	function verify_offon(&$onoff)
	{
		// Validate onoff
		$onoff = (!in_array($onoff, array('0', '1')) ? '0' : $onoff);
		
		return true;
	}
	
	/**
	* Verifies that the specified user exists
	*
	* @param	integer	User ID
	*
	* @return 	boolean	Returns true if user exists
	*/
	function verify_userid(&$userid)
	{
		if ($userid == 0)
		{
			// 0 is valid in this case 
			return true;
		}

		return parent::verify_userid($userid);
	}
	
	/**
	* Verifies that an email address is valid
	*
	* @param	string	Email address
	*
	* @return	boolean
	*/
	function verify_email(&$email)
	{
		return (is_valid_email($email) ? true : false);
	}

	/**
	* Any checks to run immediately before saving. If returning false, the save will not take place.
	*
	* @param	boolean	Do the query?
	*
	* @return	boolean	True on success; false if an error occurred
	*/
	function pre_save($doquery = true)
	{
		if ($this->presave_called !== null)
		{
			return $this->presave_called;
		}
		
		$return_value = true;
		($hook = vBulletinHook::fetch_hook('dbtech_vbmail_mailinglistdata_presave')) ? eval($hook) : false;

		$this->presave_called = $return_value;
		return $return_value;
	}
	
	/**
	* Additional data to update before a delete call (such as denormalized values in other tables).
	*
	* @param	boolean	Do the query?
	*/
	function pre_delete($doquery = true)
	{
		
		$return_value = true;
		($hook = vBulletinHook::fetch_hook('dbtech_vbmail_mailinglistdata_predelete')) ? eval($hook) : false;

		$this->presave_called = $return_value;
		return $return_value;
	}

	/**
	* Additional data to update after a save call (such as denormalized values in other tables).
	* In batch updates, is executed for each record updated.
	*
	* @param	boolean	Do the query?
	*/
	function post_save_each($doquery = true)
	{
		($hook = vBulletinHook::fetch_hook('dbtech_vbmail_mailinglistdata_postsave')) ? eval($hook) : false;

		// Rebuild the cache
		VBMAIL_CACHE::build('mailinglist');

		return true;
	}

	/**
	* Additional data to update after a delete call (such as denormalized values in other tables).
	*
	* @param	boolean	Do the query?
	*/
	function post_delete($doquery = true)
	{
		($hook = vBulletinHook::fetch_hook('dbtech_vbmail_mailinglistdata_delete')) ? eval($hook) : false;
		
		$this->dbobject->query_write("
			DELETE FROM `" . TABLE_PREFIX . "dbtech_vbmail_mail`
			WHERE mailinglistid = " . intval($this->existing['mailinglistid'])
		);
		$this->dbobject->query_write("
			DELETE FROM `" . TABLE_PREFIX . "dbtech_vbmail_subscription`
			WHERE mailinglistid = " . intval($this->existing['mailinglistid'])
		);
		$this->dbobject->query_write("
			DELETE FROM `" . TABLE_PREFIX . "dbtech_vbmail_subscriptionlog`
			WHERE mailinglistid = " . intval($this->existing['mailinglistid'])
		);
		$this->dbobject->query_write("
			DELETE FROM `" . TABLE_PREFIX . "dbtech_vbmail_subscriptionkeyword`
			WHERE mailinglistid = " . intval($this->existing['mailinglistid'])
		);
		
		// Rebuild the cache
		VBMAIL_CACHE::build('mailinglist');
		
		return true;
	}
}